#!/bin/sh

#
# Uninstallation script for Screens Connect version 1.0.
# Copyright 2012 Edovia Inc.  All rights reserved.
#

DAEMON_PLIST_FILE="/Library/LaunchDaemons/com.edovia.screensconnect.daemon.plist"
DAEMON_FILE="/Library/PrivilegedHelperTools/screens_connectd"

if [ -d "/Library/PreferencePanes/Screens Connect.prefPane" ];
then
    echo "Deleting Preference Pane";
    rm -f -r "/Library/PreferencePanes/Screens Connect.prefPane";
else
    echo "Cannot find Preference Pane!";
fi

if [ -f $DAEMON_PLIST_FILE ];
then
    echo "Deleting $DAEMON_PLIST_FILE";
    launchctl stop $DAEMON_PLIST_FILE;
    launchctl unload $DAEMON_PLIST_FILE;
    rm -f $DAEMON_PLIST_FILE;
else
    echo "Could not find $DAEMON_PLIST_FILE";
fi

if [ -f $DAEMON_FILE ];
then
    echo "Deleting $DAEMON_FILE";
    pkill -9 screens_connectd
    rm -f $DAEMON_FILE;
else
    echo "Could not find $DAEMON_FILE";
fi

defaults delete com.edovia.screens.connect.daemon

pkgutil --force --forget com.edovia.screensConnect.preflight.pkg
pkgutil --force --forget com.edovia.screensConnect.com.edovia.screensconnect.daemon.pkg
pkgutil --force --forget com.edovia.screensConnect.ScreensConnect.pkg
pkgutil --force --forget com.edovia.screensConnect.screens_connectd.pkg
